<?php

namespace Drupal\geolocation\Plugin\geolocation\DataLayerProvider;

use Drupal\geolocation\DataLayerProviderBase;
use Drupal\geolocation\DataLayerProviderInterface;
use Drupal\geolocation\MapProviderInterface;

/**
 * Provides test layer.
 *
 * @DataLayerProvider(
 *   id = "geolocation_test",
 *   name = @Translation("Test"),
 *   description = @Translation("Testing stuff."),
 * )
 */
class Test extends DataLayerProviderBase implements DataLayerProviderInterface {

  public function getLayerRenderData(string $data_layer_option_id = 'default', array $settings = [], MapProviderInterface $mapProvider = NULL, array $context = NULL): array {
    $data = parent::getLayerRenderData($data_layer_option_id, $settings, $mapProvider, $context);
    if ($data_layer_option_id !== 'default') {
      return $data;
    }

    $data[] = [
      '#type' => 'geolocation_map_location',
      '#title' => 'Test 1',
      '#coordinates' => [
        'lat' => 1,
        'lng' => 1,
      ],
    ];
    $data[] = [
      '#type' => 'geolocation_map_location',
      '#title' => 'Test 1-1',
      '#coordinates' => [
        'lat' => 1,
        'lng' => 1,
      ],
    ];
    $data[] = [
      '#type' => 'geolocation_map_location',
      '#title' => 'Test 1-2',
      '#coordinates' => [
        'lat' => 1,
        'lng' => 1,
      ],
    ];
    $data[] = [
      '#type' => 'geolocation_map_location',
      '#title' => 'Test 2',
      '#coordinates' => [
        'lat' => 11,
        'lng' => 11,
      ],
    ];
    $data[] = [
      '#type' => 'geolocation_map_location',
      '#title' => 'Test 3',
      '#coordinates' => [
        'lat' => 21,
        'lng' => 21,
      ],
    ];

    return $data;
  }

}
