<?php

namespace Drupal\geolocation\Plugin\geolocation\DataLayerProvider;

use Drupal\geolocation\DataLayerProviderBase;
use Drupal\geolocation\DataLayerProviderInterface;
use Drupal\geolocation\MapProviderInterface;

/**
 * Provides test layer.
 *
 * @DataLayerProvider(
 *   id = "geolocation_debug",
 *   name = @Translation("Debug"),
 *   description = @Translation("Debugging stuff."),
 * )
 */
class Debug extends DataLayerProviderBase implements DataLayerProviderInterface {

  public function getLayerRenderData(string $data_layer_option_id = 'default', array $settings = [], MapProviderInterface $mapProvider = NULL, array $context = NULL): array {
    $data = parent::getLayerRenderData($data_layer_option_id, $settings, $mapProvider, $context);
    if ($data_layer_option_id !== 'default') {
      return $data;
    }

    $data[] = [
      '#type' => 'geolocation_map_location',
      '#title' => 'Debug 1',
      '#coordinates' => [
        'lat' => 5,
        'lng' => 5,
      ],
    ];
    $data[] = [
      '#type' => 'geolocation_map_location',
      '#title' => 'Debug 2',
      '#coordinates' => [
        'lat' => 15,
        'lng' => 15,
      ],
    ];
    $data[] = [
      '#type' => 'geolocation_map_location',
      '#title' => 'Debug 3',
      '#coordinates' => [
        'lat' => 25,
        'lng' => 25,
      ],
    ];

    return $data;
  }

}
