<?php

namespace Drupal\geolocation;

use Drupal\Component\Plugin\PluginInspectionInterface;

/**
 * Defines an interface for geolocation DataLayer plugins.
 */
interface DataLayerProviderInterface extends PluginInspectionInterface {

  /**
   * Provide a summary array.
   *
   * @return array
   *   An array to use as field formatter summary.
   */
  public function getSettingsSummary(string $data_layer_option_id, array $settings = []): array;

  public function getSettingsForm(string $data_layer_option_id, array $settings = [], MapProviderInterface $mapProvider = NULL): array;

  public function getLayerOptions(MapProviderInterface $mapProvider = NULL, array $context = NULL): array;

  public function getLayerRenderData(string $data_layer_option_id, array $settings = []): array;

  public function alterMap(array $render_array, string $data_layer_option_id = 'default', array $settings = [], array $context = []): array;

}
