import { YandexLayerFeature } from "./YandexLayerFeature.js";

export default class YandexClusterer extends YandexLayerFeature {
  constructor(settings, map) {
    super(settings, map);

    let clusterObjects = [];

    this.map.yandexMap.geoObjects.each(function (el, i) {
      if (el.geometry === null) {
        return true;
      }
      if (typeof el.geometry === "undefined") {
        return true;
      }

      clusterObjects[i] = new ymaps.GeoObject({
        geometry: el.geometry,
      });
    });

    let clusterer = new ymaps.Clusterer();
    clusterer.add(clusterObjects);
    map.yandexMap.geoObjects.add(clusterer);
  }
}
