import { LeafletMapFeature } from "./LeafletMapFeature.js";

/**
 * @typedef {Object} WMSSettings
 *
 * @extends {GeolocationMapFeatureSettings}
 *
 * @property {String} url
 * @property {String} version
 * @property {String} layers
 * @property {String} styles
 * @property {String} srs
 * @property {String} format
 * @property {Boolean} transparent
 * @property {Boolean} identify
 */

/**
 * @property {WMSSettings} settings
 */
export default class LeafletWMS extends LeafletMapFeature {
  constructor(settings, map) {
    super(settings, map);
    let source = L.WMS.source(this.settings.url, {
      version: this.settings.version,
      styles: this.settings.styles,
      srs: this.settings.srs,
      format: this.settings.format,
      transparent: !!this.settings.transparent,
      identify: !!this.settings.identify,
    });
    source.getLayer(this.settings.layers).addTo(map.leafletMap);
  }
}
