import { LeafletMapFeature } from "./LeafletMapFeature.js";

/**
 * @typedef {Object} LeafletMaxBoundsSettings
 *
 * @extends {GeolocationMapFeatureSettings}
 *
 * @property {String} north
 * @property {String} south
 * @property {String} east
 * @property {String} west
 */

/**
 * @property {LeafletMaxBoundsSettings} settings
 */
export default class LeafletMaxBounds extends LeafletMapFeature {
  constructor(settings, map) {
    super(settings, map);

    let east = parseFloat(this.settings.east);
    let west = parseFloat(this.settings.west);
    let south = parseFloat(this.settings.south);
    let north = parseFloat(this.settings.north);
    if (west > east) {
      east = east + 360;
    }
    let bounds = new L.LatLngBounds([
      [south, west],
      [north, east],
    ]);
    map.leafletMap.setMaxBounds(bounds);
    map.leafletMap.setMinZoom(map.leafletMap.getBoundsZoom(bounds));
  }
}
