import { LeafletMapFeature } from "./LeafletMapFeature.js";

/**
 * @typedef {Object} CustomTileLayerSettings
 *
 * @extends {GeolocationMapFeatureSettings}
 *
 * @property {String} tile_layer_url
 * @property {String} tile_layer_attribution
 * @property {String} tile_layer_subdomains
 * @property {Number} tile_layer_zoom
 */

/**
 * @property {CustomTileLayerSettings} settings
 */
export default class LeafletCustomTileLayer extends LeafletMapFeature {
  constructor(settings, map) {
    super(settings, map);
    map.tileLayer.remove();
    map.tileLayer = L.tileLayer(this.settings.tile_layer_url, {
      attribution: this.settings.tile_layer_attribution,
      subdomains: this.settings.tile_layer_subdomains,
      maxZoom: this.settings.tile_layer_zoom,
    }).addTo(map.leafletMap);
  }
}
