import { LeafletMapFeature } from "./LeafletMapFeature.js";

/**
 * @typedef {Object} ControlZoomSettings
 *
 * @extends {GeolocationMapFeatureSettings}
 *
 * @property {String} position
 */

/**
 * @property {ControlZoomSettings} settings
 */
export default class LeafletControlZoom extends LeafletMapFeature {
  constructor(settings, map) {
    super(settings, map);
    L.control
      .zoom({
        position: this.settings.position,
      })
      .addTo(map.leafletMap);
  }
}
