import { LeafletMapFeature } from "./LeafletMapFeature.js";

/**
 * @typedef {Object} ControlScaleSettings
 *
 * @extends {GeolocationMapFeatureSettings}
 *
 * @property {String} position
 * @property {Boolean} metric
 * @property {Boolean} imperial
 */

/**
 * @property {ControlScaleSettings} settings
 */
export default class LeafletControlScale extends LeafletMapFeature {
  constructor(settings, map) {
    super(settings, map);
    L.control
      .scale({
        position: this.settings.position,
        metric: this.settings.metric,
        imperial: this.settings.imperial,
      })
      .addTo(map.leafletMap);
  }
}
