import { LeafletMapFeature } from "./LeafletMapFeature.js";

/**
 * @typedef {Object} ControlLayerSettings
 *
 * @extends {GeolocationMapFeatureSettings}
 *
 * @property {String} default_label
 * @property {Array} tile_layer_providers
 * @property {Array} tile_layer_options
 * @property {String} position
 */

/**
 * @property {ControlLayerSettings} settings
 */
export default class LeafletControlLayer extends LeafletMapFeature {
  constructor(settings, map) {
    super(settings, map);
    let baseMaps = {};
    baseMaps[this.settings.default_label] = map.tileLayer;
    $.each(this.settings.tile_layer_providers, function (variant, label) {
      let parts = variant.split(".");
      let provider = parts[0];
      baseMaps[label] = L.tileLayer.provider(variant, this.settings.tile_layer_options[provider] || {});
    });

    let overlayMaps = {};
    L.control
      .layers(baseMaps, overlayMaps, {
        position: this.settings.position,
      })
      .addTo(map.leafletMap);
  }
}
