import { LeafletMapFeature } from "./LeafletMapFeature.js";

/**
 * @typedef {Object} ControlAttributionSettings
 *
 * @extends {GeolocationMapFeatureSettings}
 *
 * @property {String} prefix
 * @property {String} position
 */

/**
 * @property {ControlAttributionSettings} settings
 */
export default class LeafletControlAttribution extends LeafletMapFeature {
  constructor(settings, map) {
    super(settings, map);

    if (!navigator.geolocation) {
      return;
    }

    L.control
      .attribution({
        prefix: this.settings.prefix + ' | &copy; <a href="https://osm.org/copyright">OpenStreetMap</a> contributors',
        position: this.settings.position,
      })
      .addTo(map.leafletMap);
  }
}
