import { LeafletMapFeature } from "./LeafletMapFeature.js";

export default class LeafletClientLocationIndicator extends LeafletMapFeature {
  /**
   * @param {GeolocationMapFeatureSettings} settings
   * @param {Leaflet} map
   */
  constructor(settings, map) {
    if (!navigator.geolocation) {
      return true;
    }

    super(settings, map);

    let clientLocationMarker = L.circleMarker([0, 0], {
      interactive: false,
      radius: 8,
      fillColor: "#039be5",
      fillOpacity: 1.0,
      color: "white",
      weight: 2,
    }).addTo(map.leafletMap);

    let indicatorCircle = null;

    setInterval(function () {
      navigator.geolocation.getCurrentPosition(function (currentPosition) {
        let currentLocation = L.latLng(currentPosition.coords.latitude, currentPosition.coords.longitude);
        clientLocationMarker.setLatLng(currentLocation);

        if (!indicatorCircle) {
          indicatorCircle = map.addAccuracyIndicatorCircle(currentLocation, parseInt(currentPosition.coords.accuracy.toString()));
        } else {
          indicatorCircle.setLatLng(currentLocation);
          indicatorCircle.setRadius(parseInt(currentPosition.coords.accuracy.toString()));
        }
      });
    }, 5000);
  }
}
