import { LeafletLayerFeature } from "./LeafletLayerFeature.js";

/**
 * @typedef {Object} LeafletMarkerPopupSettings
 *
 * @extends {GeolocationMapFeatureSettings}
 *
 * @property {Boolean} info_auto_display
 * @property {Number} max_width
 * @property {Number} min_width
 * @property {Number} max_height
 * @property {Boolean} auto_pan
 * @property {Boolean} keep_in_view
 * @property {Boolean} close_button
 * @property {Boolean} auto_close
 * @property {Boolean} close_on_escape_key
 * @property {String} class_name
 */

/**
 * @property {LeafletMarkerPopupSettings} settings
 */
export default class LeafletMarkerPopup extends LeafletLayerFeature {
  onMarkerAdded(marker) {
    super.onMarkerAdded(marker);

    const content = marker.getContent();

    if (!content) {
      return;
    }

    marker.leafletMarker.bindPopup(content, {
      maxWidth: Math.round(this.settings.max_width) ?? 300,
      minWidth: Math.round(this.settings.min_width) ?? 50,
      maxHeight: Math.round(this.settings.max_height) ?? null,
      autoPan: this.settings.auto_pan ?? true,
      keepInView: this.settings.keep_in_view ?? false,
      closeButton: this.settings.close_button ?? true,
      autoClose: this.settings.auto_close ?? true,
      closeOnEscapeKey: this.settings.close_on_escape_key ?? true,
      className: this.settings.class_name ?? "",
    });

    if (this.settings.infoAutoDisplay) {
      marker.leafletMarker.openPopup();
    }
  }
}
