/**
 * @typedef {Object} LeafletMarkerIconSettings
 *
 * @extends {GeolocationMapFeatureSettings}
 *
 * @property {String} markerIconPath
 * @property {Array} iconSize
 * @property {Number} iconSize.width
 * @property {Number} iconSize.height
 * @property {Array} iconAnchor
 * @property {Number} iconAnchor.x
 * @property {Number} iconAnchor.y
 * @property {Array} popupAnchor
 * @property {Number} popupAnchor.x
 * @property {Number} popupAnchor.y
 * @property {String} markerShadowPath
 * @property {Array} shadowSize
 * @property {Number} shadowSize.width
 * @property {Number} shadowSize.height
 * @property {Array} shadowAnchor
 * @property {Number} shadowAnchor.x
 * @property {Number} shadowAnchor.y
 */

import {LeafletLayerFeature} from "./LeafletLayerFeature.js";

/**
 * @property {LeafletMarkerIconSettings} settings
 */
export default class LeafletControlScale extends LeafletLayerFeature {
  onMarkerAdded(marker) {
    super.onMarkerAdded(marker);

    let iconUrl;
    let currentIcon;
    if (typeof marker.wrapper !== "undefined") {
      currentIcon = marker.wrapper.data("icon");
    }

    if (typeof currentIcon === "undefined") {
      if (typeof this.settings.markerIconPath === "string") {
        iconUrl = this.settings.markerIconPath;
      } else {
        return;
      }
    } else {
      iconUrl = currentIcon;
    }

    let iconOptions = {
      iconUrl: iconUrl,
      shadowUrl: this.settings.markerShadowPath,
    };

    if (this.settings.iconSize.width && this.settings.iconSize.height) {
      iconOptions.iconSize = [this.settings.iconSize.width, this.settings.iconSize.height];
    }

    if (this.settings.shadowSize.width && this.settings.shadowSize.height) {
      iconOptions.shadowSize = [this.settings.shadowSize.width, this.settings.shadowSize.height];
    }

    if (this.settings.iconAnchor.x || this.settings.iconAnchor.y) {
      iconOptions.iconAnchor = [this.settings.iconAnchor.x, this.settings.iconAnchor.y];
    }

    if (this.settings.shadowAnchor.x || this.settings.shadowAnchor.y) {
      iconOptions.shadowAnchor = [this.settings.shadowAnchor.x, this.settings.shadowAnchor.y];
    }

    if (this.settings.popupAnchor.x || this.settings.popupAnchor.y) {
      iconOptions.popupAnchor = [this.settings.popupAnchor.x, this.settings.popupAnchor.y];
    }

    marker.leafletMarker.setIcon(L.icon(iconOptions));
  }
}
