import { GoogleMapFeature } from "./GoogleMapFeature.js";

/* global google */

/**
 * @typedef {Object} MapRestrictionSettings
 *
 * @extends {GeolocationMapFeatureSettings}
 *
 * @property {String} north
 * @property {String} south
 * @property {String} east
 * @property {String} west
 * @property {Boolean} strict
 */

/**
 * @property {MapRestrictionSettings} settings
 * @property {GoogleMaps} map
 */
export default class GoogleMapRestriction extends GoogleMapFeature {
  constructor(settings, map) {
    super(settings, map);

    this.map.googleMap.setOptions({
      restriction: {
        latLngBounds: {
          north: parseFloat(this.settings.north),
          south: parseFloat(this.settings.south),
          east: parseFloat(this.settings.east),
          west: parseFloat(this.settings.west),
        },
        strictBounds: Boolean(this.settings.strict),
      },
    });
  }
}
