import { GoogleMapFeature } from "./GoogleMapFeature.js";

/* global google */
export default class GoogleMapDisablePOI extends GoogleMapFeature {
  /**
   * @param {GeolocationMapFeatureSettings} settings
   * @param {GeolocationMapBase} map
   */
  constructor(settings, map) {
    super(settings, map);

    let styles = [];
    if (this.map.googleMap.styles) {
      styles = styles.concat(this.map.googleMap.styles);
    }
    styles = styles.concat([
      {
        featureType: "poi",
        stylers: [{ visibility: "off" }],
      },
    ]);

    this.map.googleMap.setOptions({ styles: styles });
  }
}
