import { GoogleMapFeature } from "./GoogleMapFeature.js";

/* global google */

/**
 * @typedef {Object} ControlZoomSettings
 *
 * @extends {GeolocationMapFeatureSettings}
 *
 * @property {String} behavior
 * @property {String} position
 * @property {String} style
 */
export default class GoogleControlZoom extends GoogleMapFeature {
  /**
   * @param {ControlZoomSettings} settings
   * @param {GeolocationMapBase} map
   */
  constructor(settings, map) {
    super(settings, map);

    this.map.googleMap.setOptions({
      zoomControlOptions: {
        position: google.maps.ControlPosition[this.settings.position],
        style: google.maps.ZoomControlStyle[this.settings.style],
      },
      zoomControl: this.settings.behavior === "always" ? true : undefined,
    });
  }
}
