import { GoogleMapFeature } from "./GoogleMapFeature.js";

/**
 * @typedef {Object} ControlStreetViewSettings
 *
 * @extends {GeolocationMapFeatureSettings}

 * @property {String} position
 * @property {String} behavior
 */

/* global google */
export default class GoogleControlStreetView extends GoogleMapFeature {
  /**
   * @param {ControlStreetViewSettings} settings
   * @param {GeolocationMapBase} map
   */
  constructor(settings, map) {
    super(settings, map);

    this.map.googleMap.setOptions({
      streetViewControlOptions: {
        position: google.maps.ControlPosition[this.settings.position],
      },
      streetViewControl: this.settings.behavior === "always" ? true : undefined,
    });
  }
}
