import { GoogleMapFeature } from "./GoogleMapFeature.js";

/* global google */

/**
 * @typedef {Object} ControlRotateSettings
 *
 * @extends {GeolocationMapFeatureSettings}

 * @property {String} position
 * @property {String} behavior
 */

export default class GoogleControlRotate extends GoogleMapFeature {
  /**
   * @param {ControlRotateSettings} settings
   * @param {GeolocationMapBase} map
   */
  constructor(settings, map) {
    super(settings, map);

    this.map.googleMap.setOptions({
      rotateControlOptions: {
        position: google.maps.ControlPosition[this.settings.position],
      },
      rotateControl: this.settings.behavior === "always" ? true : undefined,
    });
  }
}
