import { GoogleMapFeature } from "./GoogleMapFeature.js";

/* global google */

/**
 * @typedef {Object} ControlMapTypeSettings
 *
 * @extends {GeolocationMapFeatureSettings}
 *
 * @property {String} position
 * @property {String} style
 * @property {String} behavior
 */
export default class GoogleControlMapType extends GoogleMapFeature {
  /**
   * @param {ControlMapTypeSettings} settings
   * @param {GeolocationMapBase} map
   */
  constructor(settings, map) {
    super(settings, map);

    this.map.googleMap.setOptions({
      mapTypeControlOptions: {
        position: google.maps.ControlPosition[this.settings.position],
        style: google.maps.MapTypeControlStyle[this.settings.style],
      },
      mapTypeControl: this.settings.behavior === "always" ? true : undefined,
    });
  }
}
