import { GoogleMapFeature } from "./GoogleMapFeature.js";

/* global google */

/**
 * @typedef {Object} ControlFullscreenSettings
 *
 * @extends {GeolocationMapFeatureSettings}

 * @property {String} position
 * @property {String} behavior
 */
export default class GoogleControlFullscreen extends GoogleMapFeature {
  /**
   * @param {ControlFullscreenSettings} settings
   * @param {GeolocationMapBase} map
   */
  constructor(settings, map) {
    super(settings, map);

    this.map.googleMap.setOptions({
      fullscreenControlOptions: {
        position: google.maps.ControlPosition[this.settings.position],
      },
      fullscreenControl: this.settings.behavior === "always" ? true : undefined,
    });
  }
}
