import { GoogleMapFeature } from "./GoogleMapFeature.js";
import { GeolocationCoordinates } from "../../../../js/GeolocationCoordinates.js";

/* global google */
export default class GoogleControlCustomLocate extends GoogleMapFeature {
  /**
   * @param {GeolocationMapFeatureSettings} settings
   * @param {GeolocationMapBase} map
   */
  constructor(settings, map) {
    super(settings, map);

    let locateButton = this.map.wrapper.querySelector(".geolocation-map-control .locate");

    if (navigator.geolocation && window.location.protocol === "https:") {
      locateButton.addEventListener(
        "click",
        (e) => {
          navigator.geolocation.getCurrentPosition(function (currentPosition) {
            this.map.setCenterByCoordinates(new GeolocationCoordinates(currentPosition.coords.latitude, currentPosition.coords.longitude), currentPosition.coords.accuracy);
          });
          e.preventDefault();
        },
        false
      );
    } else {
      locateButton.parentNode.removeChild(locateButton);
    }
  }
}
