import { GoogleLayerFeature } from "./GoogleLayerFeature.js";

/**
 * @typedef {Object} MarkerOpacitySettings
 *
 * @extends {GeolocationMapFeatureSettings}
 *
 * @property {String} opacity
 */

/* global google */
export default class GoogleMarkerOpacity extends GoogleLayerFeature {

  onMarkerAdded(marker) {
    super.onMarkerAdded(marker);

    marker.googleMarker.setOpacity(parseFloat(this.settings.opacity));
  }
}
