import { GoogleLayerFeature } from "./GoogleLayerFeature.js";

/**
 * @typedef {Object} MarkerLabelSettings
 *
 * @extends {GeolocationMapFeatureSettings}
 *
 * @property {String} color
 * @property {String} fontFamily
 * @property {String} fontSize
 * @property {String} fontWeight
 */

/* global google */
export default class GoogleMarkerLabel extends GoogleLayerFeature {
  onMarkerAdded(marker) {
    super.onMarkerAdded(marker);

    let currentLabel = marker.googleMarker.getLabel();
    if (!currentLabel) {
      return;
    }

    let text = typeof currentLabel === "string" ? currentLabel : currentLabel.text;
    if (!text) {
      return;
    }

    marker.googleMarker.setLabel({
      text: text,
      color: this.settings.color ?? undefined,
      fontFamily: this.settings.font_family ?? undefined,
      fontWeight: this.settings.font_weight ?? undefined,
      fontSize: this.settings.font_size ?? undefined,
    });
  }
}
