import { GoogleLayerFeature } from "./GoogleLayerFeature.js";

/**
 * @typedef {Object} MarkerInfoWindowSettings
 *
 * @extends {GeolocationMapFeatureSettings}
 *
 * @property {Boolean} info_auto_display
 * @property {Boolean} disable_auto_pan
 * @property {Boolean} info_window_solitary
 * @property {int} max_width
 */

/**
 * @typedef {Object} GoogleInfoWindow
 * @property {Function} open
 * @property {Function} close
 */

/**
 * @property {MarkerInfoWindowSettings} settings
 * @property {GoogleInfoWindow} GeolocationGoogleMap.infoWindow
 * @property {function({}):GoogleInfoWindow} GeolocationGoogleMap.InfoWindow
 */
export default class GoogleMarkerInfoWindow extends GoogleLayerFeature {

  onMarkerClicked(marker) {
    super.onMarkerClicked(marker);

    if (this.settings.info_window_solitary) {
      for (const currentMarker of this.map.dataLayers.get('default').markers) {
        if (currentMarker.infoWindow) {
          currentMarker.infoWindow.close();
        }
      }
    }

    if (marker.infoWindow) {
      marker.infoWindow.open({
        anchor: marker.googleMarker,
        map: this.map.googleMap,
        shouldFocus: true,
      });
    }
  }

  onMarkerAdded(marker) {
    super.onMarkerAdded(marker);

    // Set the info popup text.
    marker.infoWindow = new google.maps.InfoWindow({
      content: marker.getContent(),
      disableAutoPan: this.settings.disable_auto_pan,
      maxWidth: this.settings.max_width ?? undefined,
    });

    if (this.settings.info_auto_display) {
      for (const currentMarker of this.map.dataLayers.get('default').markers) {
        if (currentMarker.infoWindow) {
          currentMarker.infoWindow.open({
            anchor: currentMarker.googleMarker,
            map: this.map.googleMap,
            shouldFocus: false,
          });
        }
      }
    }
  }
}
