import { GoogleLayerFeature } from "./GoogleLayerFeature.js";

/**
 * @typedef {Object} MarkerIconSettings
 *
 * @extends {GeolocationMapFeatureSettings}
 *
 * @property {String} marker_icon_path
 * @property {Array} anchor
 * @property {Number} anchor.x
 * @property {Number} anchor.y
 * @property {Array} label_origin
 * @property {Number} label_origin.x
 * @property {Number} label_origin.y
 * @property {Array} origin
 * @property {Number} origin.x
 * @property {Number} origin.y
 * @property {Array} size
 * @property {Number} size.width
 * @property {Number} size.height
 * @property {Array} scaled_size
 * @property {Number} scaled_size.width
 * @property {Number} scaled_size.height
 */

/**
 * @property {MarkerIconSettings} settings
 */
export default class GoogleMarkerIcon extends GoogleLayerFeature {
  onMarkerAdded(marker) {
    let newIcon = {};

    let currentIcon = marker.googleMarker.getIcon();
    if (typeof currentIcon === "undefined") {
      if (typeof this.settings.markerIconPath === "string") {
        newIcon.url = this.settings.markerIconPath;
      } else {
        return;
      }
    } else if (typeof currentIcon === "string") {
      newIcon.url = currentIcon;
    } else if (typeof currentIcon.url === "string") {
      newIcon.url = currentIcon.url;
    }

    let anchorX = marker.wrapper.getAttribute("data-marker-icon-anchor-x") || this.settings.anchor.x;
    let anchorY = marker.wrapper.getAttribute("data-marker-icon-anchor-y") || this.settings.anchor.y;
    let labelOriginX = marker.wrapper.getAttribute("data-marker-icon-label-origin-x") || this.settings.label_origin.x;
    let labelOriginY = marker.wrapper.getAttribute("data-marker-icon-label-origin-y") || this.settings.label_origin.y;
    let originX = marker.wrapper.getAttribute("data-marker-icon-origin-x") || this.settings.origin.x;
    let originY = marker.wrapper.getAttribute("data-marker-icon-origin-y") || this.settings.origin.y;
    let sizeWidth = marker.wrapper.getAttribute("data-marker-icon-size-width") || this.settings.size.width;
    let sizeHeight = marker.wrapper.getAttribute("data-marker-icon-size-height") || this.settings.size.height;
    let scaledSizeWidth = marker.wrapper.getAttribute("data-marker-icon-scaled-size-width") || this.settings.scaled_size.width;
    let scaledSizeHeight = marker.wrapper.getAttribute("data-marker-icon-scaled-size-height") || this.settings.scaled_size.height;

    if (anchorX !== null && anchorY !== null) {
      newIcon.anchor = new google.maps.Point(anchorX, anchorY);
    }

    if (labelOriginX !== null && labelOriginY !== null) {
      newIcon.labelOrigin = new google.maps.Point(labelOriginX, labelOriginY);
    }

    if (originX !== null && originY !== null) {
      newIcon.origin = new google.maps.Point(originX, originY);
    }

    if (sizeWidth !== null && sizeHeight !== null) {
      newIcon.size = new google.maps.Size(sizeWidth, sizeHeight);
    }

    if (scaledSizeWidth !== null && scaledSizeHeight !== null) {
      newIcon.scaledSize = new google.maps.Size(scaledSizeWidth, scaledSizeHeight);
    }

    marker.googleMarker.setIcon(newIcon);
  }
}
