import { GoogleLayerFeature } from "./GoogleLayerFeature.js";

/**
 * @typedef {Object} MarkerClustererSettings
 *
 * @extends {GeolocationMapFeatureSettings}
 *
 * @property {String} image_path
 * @property {Object} styles
 * @property {Number} max_zoom
 * @property {Number} grid_size
 * @property {Boolean} zoom_on_click
 * @property {Number} average_center
 * @property {Number} minimum_cluster_size
 */

/* global google */
/* global markerClusterer */

/**
 * @property {MarkerClustererSettings} settings
 */
export default class GoogleMarkerClusterer extends GoogleLayerFeature {

  constructor(settings, layer) {
    super(settings, layer);

    if (typeof markerClusterer === "undefined") {
      throw "MarkerCluster not found";
    }

    this.markerClusterer = new markerClusterer.MarkerClusterer({
      map: this.layer.map.googleMap,
    });
  }

  onMarkerAdded(marker) {
    super.onMarkerAdded(marker);

    this.markerClusterer.addMarker(marker.googleMarker);
  }

  onMarkerRemove(marker) {
    super.onMarkerRemove(marker);

    this.markerClusterer.removeMarker(marker.googleMarker);

  }
}
