<?php

namespace Drupal\geolocation_geometry\GeometryType;

use Exception;

/**
 * @property \Drupal\geolocation_geometry\GeometryType\Polygon[] $components
 */
class MultiPolygon extends Collection {

  public function __construct($components) {
    parent::__construct();

    foreach ($components as $comp) {
      if (!($comp instanceof Polygon)) {
        throw new Exception("MultiPolygon can only contain Polygon elements");
      }
    }
    $this->components = $components;
  }
}

