<?php

namespace Drupal\geolocation_geometry\GeometryType;

use Exception;

/**
 * @property \Drupal\geolocation_geometry\GeometryType\LineString[] $components
 */
class MultiLineString extends Collection {

  public function __construct($components) {
    parent::__construct();

    foreach ($components as $comp) {
      if (!($comp instanceof LineString)) {
        throw new Exception("MultiLineString can only contain LineString elements");
      }
    }
    $this->components = $components;
  }

}

