<?php

namespace Drupal\geolocation_geometry\GeometryType;

use Drupal\geolocation_geometry\GeometryType\GeometryTypeInterface;
use ReflectionClass;

abstract class GeometryTypeBase implements GeometryTypeInterface {

  protected string $type;

  /** @var GeometryTypeInterface[] */
  protected array $components;

  public function __construct() {
    $this->type = (new ReflectionClass($this))->getShortName();
  }

  /**
   * Calculates the great-circle distance between two points, with the Vincenty formula.
   */
  public static function distanceByCoordinates(float $latitudeFrom, float $longitudeFrom, float $latitudeTo, float $longitudeTo, float $earthRadius = 6371000): float {
    // convert from degrees to radians
    $latFrom = deg2rad($latitudeFrom);
    $lonFrom = deg2rad($longitudeFrom);
    $latTo = deg2rad($latitudeTo);
    $lonTo = deg2rad($longitudeTo);

    $lonDelta = $lonTo - $lonFrom;
    $a = pow(cos($latTo) * sin($lonDelta), 2) +
      pow(cos($latFrom) * sin($latTo) - sin($latFrom) * cos($latTo) * cos($lonDelta), 2);
    $b = sin($latFrom) * sin($latTo) + cos($latFrom) * cos($latTo) * cos($lonDelta);

    $angle = atan2(sqrt($a), $b);
    return $angle * $earthRadius;
  }

}
