<?php

namespace Drupal\geolocation_geometry\GeometryFormat;

use Drupal\geolocation_geometry\GeometryType\GeometryCollection;

abstract class XML {
  static public function geomFromText($text) {

    $xmlobj = simplexml_load_string($text);
    if ($xmlobj === FALSE) {
      throw new \Exception("Could not parse Geometry");
    }

    try {
      $geometry = static::_geomFromXML($xmlobj);
    } catch(\Exception $e) {
      throw new \Exception("Could not parse Geometry");
    }

    return $geometry;
  }

  static protected function childElements($xml, $nodename = "") {
    $nodename = strtolower($nodename);
    $res = array();
    foreach ($xml->children() as $child) {
      if ($nodename) {
        if (strtolower($child->getName()) == $nodename) {
          array_push($res, $child);
        }
      } else {
        array_push($res, $child);
      }
    }
    return $res;
  }

  static protected function _childsCollect($xml) {
    $components = array();
    foreach (static::childElements($xml) as $child) {
      try {
        $geometry = static::_geomFromXML($child);
        $components[] = $geometry;
      } catch(\Exception $e) {
      }
    }

    $ncomp = count($components);
    if ($ncomp == 0) {
      throw new \Exception("Could not parse Geometry");
    } else if ($ncomp == 1) {
      return $components[0];
    } else {
      return new GeometryCollection($components);
    }
  }
}
