<?php

namespace Drupal\geolocation_geometry\GeometryFormat;

use Drupal\geolocation_geometry\GeometryType\GeometryCollection;
use Drupal\geolocation_geometry\GeometryType\LinearRing;
use Drupal\geolocation_geometry\GeometryType\MultiLineString;
use Drupal\geolocation_geometry\GeometryType\MultiPoint;
use Drupal\geolocation_geometry\GeometryType\MultiPolygon;
use Drupal\geolocation_geometry\GeometryType\Point;

class KML extends XML {

  static protected function parsePoint($xml) {
    $coordinates = static::_extractCoordinates($xml);

    $coords = explode(',', $coordinates[0]);
    return array_map("trim", $coords);
  }

  static protected function parseLineString($xml) {
    $coordinates = static::_extractCoordinates($xml);
    foreach (preg_split('/\s+/', trim((string)$coordinates[0])) as $compstr) {
      $coords = explode(',', $compstr);
      $components[] = new Point($coords);
    }
    return $components;
  }

  static protected function parseLinearRing($xml) {
    return static::parseLineString($xml);
  }

  static protected function parsePolygon($xml) {
    $ring = array();
    foreach (static::childElements($xml, 'outerboundaryis') as $elem) {
      $ring = array_merge($ring, static::childElements($elem, 'linearring'));
    }

    if (count($ring) != 1) {
      throw new \Exception("Could not parse Geometry");
    }

    $components = array(new LinearRing(static::parseLinearRing($ring[0])));
    foreach (static::childElements($xml, 'innerboundaryis') as $elem) {
      foreach (static::childElements($elem, 'linearring') as $ring) {
        $components[] = new LinearRing(static::parseLinearRing($ring[0]));
      }
    }
    return $components;
  }

  static protected function parseMultiGeometry($xml) {
    $components = array();
    foreach ($xml->children() as $child) {
      $components[] = static::_geomFromXML($child);
    }
    return $components;
  }

  static protected function _extractCoordinates($xml) {
    $coordinates = static::childElements($xml, 'coordinates');
    if (count($coordinates) != 1) {
      throw new \Exception("Could not parse Geometry");
    }
    return $coordinates;
  }

  static protected function _geomFromXML($xml) {
    $nodename = strtolower($xml->getName());
    if ($nodename == "kml" or $nodename == "document" or $nodename == "placemark") {
      return static::_childsCollect($xml);
    }

    foreach (array("Point", "LineString", "LinearRing", "Polygon", "MultiGeometry") as $kml_type) {
      if (strtolower($kml_type) == $nodename) {
        $type = $kml_type;
        break;
      }
    }

    if (!isset($type)) {
      throw new \Exception("Could not parse Geometry");
    }

    try {
      $components = call_user_func(array('static', 'parse'.$type), $xml);
    }
    catch(\Exception $e) {
      throw new \Exception("Could not parse Geometry");
    }

    if ($type == "MultiGeometry") {
      if (count($components)) {
        $possibletype = $components[0]::TYPE;
        $sametype = TRUE;
        foreach (array_slice($components, 1) as $component) {
          if ($component::TYPE != $possibletype) {
            $sametype = FALSE;
            break;
          }
        }
        if ($sametype) {
          switch ($possibletype) {
            case "Point":
              return new MultiPoint($components);

            case "LineString":
              return new MultiLineString($components);

            case "Polygon":
              return new MultiPolygon($components);

            default:
              break;
          }
        }
      }
      return new GeometryCollection($components);
    }

    $constructor = __NAMESPACE__ . '\\' . $type;
    return new $constructor($components);
  }
}
