<?php

namespace Drupal\geolocation_geometry\GeometryFormat;

use Drupal\geolocation_geometry\GeometryType\Point;

class GPX extends XML {

  static protected function _extractCoordinates($xml) {
    $attributes = $xml->attributes();
    $longitude = (string) $attributes['lon'];
    $latitude = (string) $attributes['lat'];
    if (!$longitude || !$latitude) {
      throw new \Exception("Could not parse Geometry");
    }
    return [$longitude, $latitude];
  }

  static protected function parseTrkseg($xml) {
    $res = [];
    foreach ($xml->children() as $elem) {
      if (strtolower($elem->getName()) == "trkpt") {
        $res[] = new Point(static::_extractCoordinates($elem));
      }
    }
    return $res;
  }

  static protected function parseRte($xml) {
    $res = [];
    foreach ($xml->children() as $elem) {
      if (strtolower($elem->getName()) == "rtept") {
        $res[] = new Point(static::_extractCoordinates($elem));
      }
    }
    return $res;
  }

  static protected function parseWpt($xml) {
    return static::_extractCoordinates($xml);
  }

  static protected function _geomFromXML($xml) {
    $nodename = strtolower($xml->getName());
    if ($nodename == "gpx" or $nodename == "trk") {
      return static::_childsCollect($xml);
    }
    foreach (["Trkseg", "Rte", "Wpt"] as $kml_type) {
      if (strtolower($kml_type) == $xml->getName()) {
        $type = $kml_type;
        break;
      }
    }

    if (!isset($type)) {
      throw new \Exception("Could not parse Geometry");
    }

    try {
      $components = call_user_func(array('static', 'parse'.$type), $xml);
    } catch(\Exception $e) {
      throw new \Exception("Could not parse Geometry");
    }

    if ($type == "Trkseg" or $type == "Rte") {
      $constructor = __NAMESPACE__ . '\\' . 'LineString';
    } else if ($type == "Wpt") {
      $constructor = __NAMESPACE__ . '\\' . 'Point';
    }
    return new $constructor($components);
  }
}
