import { BaiduMapFeature } from "./BaiduMapFeature.js";

/**
 * @property {Baidu} map
 * @property {Object} settings
 * @property {String} settings.type
 * @property {String} settings.position
 */
export default class BaiduZoomControl extends BaiduMapFeature {
  constructor(settings, map) {
    super(settings, map);

    this.map.baiduMap.addControl(
      new BMapGL.ZoomControl({
        anchor: this.settings.position,
      })
    );
  }
}
