/**
 * @name GeolocationWidgetSettings
 *
 * @property {String} autoClientLocationMarker
 * @property {jQuery} wrapper
 * @property {String} id
 * @property {String} type
 * @property {String} fieldName
 * @property {String} cardinality
 */

import { GeolocationFieldWidgetBase } from "./GeolocationFieldWidgetBase.js";
import { GeolocationCoordinates } from "../GeolocationCoordinates.js";

export default class GeolocationFieldWidget extends GeolocationFieldWidgetBase {

  /**
   * @param {GeolocationCoordinates|null} coordinates
   * @param {Element} element
   */
  setValueByElement(coordinates, element) {
    let latitudeInput = element.querySelector("input.geolocation-input-latitude");
    let longitudeInput = element.querySelector("input.geolocation-input-longitude");

    if (!longitudeInput || !latitudeInput) {
      return null;
    }

    if (coordinates) {
      latitudeInput.value = coordinates.lat;
      latitudeInput.setAttribute("data-geolocation-current-value", coordinates.lat.toString());

      longitudeInput.value = coordinates.lng;
      longitudeInput.setAttribute("data-geolocation-current-value", coordinates.lng.toString());
    } else {
      latitudeInput.value = "";
      latitudeInput.setAttribute("data-geolocation-current-value", "");

      longitudeInput.value = "";
      longitudeInput.setAttribute("data-geolocation-current-value", "");
    }
  }

  /**
   * @param {Element} element
   */
  getValueByElement(element) {
    let latitude = element.querySelector("input.geolocation-input-latitude").value;
    let longitude = element.querySelector("input.geolocation-input-longitude").value;

    if (!longitude || !latitude) {
      return null;
    }

    return new GeolocationCoordinates(latitude, longitude);
  }

  setStoredValuesByElement(newValue, element) {
    element.querySelector("input.geolocation-input-latitude").setAttribute("data-geolocation-current-value", newValue.lat);
    element.querySelector("input.geolocation-input-longitude").setAttribute("data-geolocation-current-value", newValue.lng);
  }

  getStoredValuesByElement(element) {
    let latitudeInput = element.querySelector("input.geolocation-input-latitude");
    let longitudeInput = element.querySelector("input.geolocation-input-longitude");

    let latitude;
    if (latitudeInput.hasAttribute("data-geolocation-current-value")) {
      latitude = latitudeInput.getAttribute("data-geolocation-current-value");
    } else {
      latitude = latitudeInput.defaultValue ?? null;
    }

    let longitude;
    if (latitudeInput.hasAttribute("data-geolocation-current-value")) {
      longitude = longitudeInput.getAttribute("data-geolocation-current-value");
    } else {
      longitude = longitudeInput.defaultValue ?? null;
    }

    if (!longitude || !latitude) {
      return null;
    }

    return new GeolocationCoordinates(latitude, longitude);
  }

  alterValue(coordinates, delta, source) {
    const currentCoordinates = this.getValueByElement(this.getElementByDelta(delta));

    if (currentCoordinates === coordinates) {
      return;
    }

    super.alterValue(coordinates, delta, source);
  }

}
