/**
 * @name GeolocationWidgetSettings
 *
 * @property {String} autoClientLocationMarker
 * @property {jQuery} wrapper
 * @property {String} id
 * @property {String} type
 * @property {String} fieldName
 * @property {String} cardinality
 */

import { GeolocationFieldWidgetBase } from "./GeolocationFieldWidgetBase.js";

export default class EntityReferenceFieldWidget extends GeolocationFieldWidgetBase {

  /**
   * @param {String} value
   * @param {HTMLInputElement} element
   */
  setValueByElement(value, element) {
    if (value) {
      element.value = value;
      element.setAttribute("data-geolocation-current-value", value);
    } else {
      element.value = "";
      element.setAttribute("data-geolocation-current-value", "");
    }
  }

  /**
   * @param {HTMLInputElement} element
   */
  getValueByElement(element) {
    return element.value;
  }

  /**
   * @param {String} value
   * @param {HTMLInputElement} element
   */
  setStoredValuesByElement(value, element) {
    element.setAttribute("data-geolocation-current-value", value);
  }

  /**
   * @param {HTMLInputElement} element
   */
  getStoredValuesByElement(element) {
    if (element.hasAttribute("data-geolocation-current-value")) {
      return element.getAttribute("data-geolocation-current-value");
    }

    return element.defaultValue ?? null;
  }

}
