import { GeolocationWidgetSubscriberBase } from "./GeolocationWidgetSubscriberBase.js";

/**
 * @property {GeolocationMapBase} map
 * @property {FieldWidgetMapConnectorBase} mapFeature
 */
export default class EntityReferenceFieldMapWidget extends GeolocationWidgetSubscriberBase {

  constructor(broker, settings) {
    super(broker, settings);

    Drupal.geolocation.maps.getMap(settings.mapId).then((map) => {
      this.map = map;
      this.map.loadFeature(this.settings.featureSettings).then(
        /** @param {FieldWidgetMapConnectorBase} feature */ (feature) => {
          this.mapFeature = feature;
          if (typeof this.mapFeature.setWidgetSubscriber === "function") {
            this.mapFeature.setWidgetSubscriber(this);
          }
        }
      );
    });
  }

  addValue(coordinates, delta, source) {
    super.addValue(coordinates, delta, source);

    const marker = this.map.createMarker(coordinates, {
      title: this.getMarkerTitle(delta, coordinates),
      draggable: true,
    });
    this.mapFeature.setDeltaByMarker(marker, delta);

    this.map.addMapMarker(marker);
  }

  removeValue(delta, source) {
    super.removeValue(delta, source);

    const marker = this.getMarkerByDelta(delta);
    this.map.removeMapMarker(marker);
  }

  alterValue(coordinates, delta, source) {
    super.alterValue(coordinates, delta, source);

    const marker = this.getMarkerByDelta(delta);

    if (marker.coordinates === coordinates) {
      return;
    }

    this.map.updateMapMarker(marker);
  }
}
