/**
 * @typedef {Object} GeolocationMapFeatureSettings
 *
 * @property {String} import_path
 * @property {Object} settings
 * @property {String[]} scripts
 * @property {String[]} stylesheets
 */

/**
 * Base class.
 *
 * @property {GeolocationMapFeatureSettings} settings
 * @property {GeolocationMapBase} map
 */
export class GeolocationMapFeature {
  /**
   * @constructor
   *
   * @param {GeolocationMapFeatureSettings} settings
   * @param {GeolocationMapBase} map
   */
  constructor(settings, map) {
    this.settings = settings;
    this.map = map;
  }

  /**
   * Click somewhere on map.
   *
   * @param {GeolocationCoordinates} coordinates
   */
  onClick(coordinates) {}

  /**
   * Click somewhere on map.
   *
   * @param {GeolocationCoordinates} coordinates
   */
  onDoubleClick(coordinates) {}

  /**
   * Click somewhere on map.
   *
   * @param {GeolocationCoordinates} coordinates
   */
  onContextClick(coordinates) {}

  onMapReady() {}

  onMapIdle() {}

  /**
   * @param {GeolocationBoundaries} bounds
   */
  onBoundsChanged(bounds) {}

  /**
   * @param {GeolocationMapMarker} marker
   */
  onMarkerAdded(marker) {}

  /**
   * @param {GeolocationMapMarker} marker
   */
  onMarkerUpdated(marker) {}

  /**
   * @param {GeolocationMapMarker} marker
   */
  onMarkerRemove(marker) {}

  /**
   * @param {GeolocationMapMarker} marker
   */
  onMarkerClicked(marker) {}

  /**
   * @param {GeolocationShape} shape
   */
  onShapeAdded(shape) {}

  /**
   * @param {GeolocationShape} shape
   */
  onShapeUpdated(shape) {}

  /**
   * @param {GeolocationShape} shape
   */
  onShapeRemove(shape) {}

  /**
   * @param {GeolocationShape} shape
   */
  onShapeClicked(shape) {}
}
