import {FieldWidgetMapConnectorBase} from "./FieldWidgetMapConnectorBase.js";

/**
 * @property {GeolocationWidgetSubscriberBase} subscriber
 */
export default class GeolocationFieldWidgetMapConnector extends FieldWidgetMapConnectorBase {

  onClick(coordinates) {
    super.onClick(coordinates);

    if (this.subscriber.broker.settings.cardinality > 0 && this.map.dataLayers.get('default').markers.length >= this.subscriber.broker.settings.cardinality) {
      alert(Drupal.t("Maximum number of entries reached. Cardinality set to " + this.subscriber.broker.settings.cardinality));
      return;
    }

    let newDelta = 0;
    for (const marker of this.map.dataLayers.get('default').markers) {
      let markerDelta = this.getDeltaByMarker(marker) ?? 0;
      if (markerDelta >= newDelta) {
        newDelta = markerDelta + 1;
      }
    }

    this.subscriber.addValue(coordinates, newDelta, this.subscriber.constructor.name);
  }

  onMarkerAdded(marker) {
    super.onMarkerAdded(marker);

    this.subscriber.broker.valueAdded(marker.coordinates, this.getDeltaByMarker(marker) ?? 0, this.subscriber.constructor.name);
  }

  onMarkerClicked(marker) {
    super.onMarkerClicked(marker);

    marker.remove();
  }

  onMarkerUpdated(marker) {
    super.onMarkerUpdated(marker);

    this.subscriber.broker.valueAltered(marker.coordinates, this.getDeltaByMarker(marker), this.subscriber.constructor.name);
  }

  onMarkerRemove(marker) {
    super.onMarkerRemove(marker);

    this.subscriber.broker.valueRemoved(this.getDeltaByMarker(marker), this.subscriber.constructor.name);
  }
}
