import { GeolocationMapFeature } from "./GeolocationMapFeature.js";

/**
 * @property {GeolocationWidgetSubscriberBase} subscriber
 * @property {Object} settings
 * @property {String} settings.markerSelectedIconPath
 * @property {String} settings.markerOptionalIconPath
 */
export class FieldWidgetMapConnectorBase extends GeolocationMapFeature {
  setWidgetSubscriber(subscriber) {
    this.subscriber = subscriber;
  }

  /**
   * @param {GeolocationMapMarker} marker
   *
   * @return {int|null}
   */
  getDeltaByMarker(marker) {
    return Number(marker.wrapper.dataset.geolocationWidgetDelta) ?? null;
  }

  /**
   * @param {int} delta
   *
   * @return {GeolocationMapMarker|null}
   */
  getMarkerByDelta(delta) {
    for (const marker of this.map.dataLayers.get('default').markers) {
      if (delta === this.getDeltaByMarker(marker)) {
        return marker;
      }
    }

    return null;
  }

  /**
   * @param {GeolocationMapMarker} marker
   * @param {int|false} delta
   *
   * @return {int|null}
   */
  setDeltaByMarker(marker, delta = false) {
    if (delta === false) {
      delete marker.wrapper.dataset.geolocationWidgetDelta;
    }
    else {
      marker.wrapper.dataset.geolocationWidgetDelta = delta.toString();
    }
  }

}
