import {FieldWidgetMapConnectorBase} from "./FieldWidgetMapConnectorBase.js";

/**
 * @property {GeolocationWidgetSubscriberBase} subscriber
 * @property {Object} settings
 * @property {String} settings.markerSelectedIconPath
 * @property {String} settings.markerOptionalIconPath
 */
export default class EntityReferenceFieldWidgetMapConnector extends FieldWidgetMapConnectorBase {

  onMarkerClicked(marker) {
    super.onMarkerClicked(marker);

    switch (marker.wrapper.dataset.geolocationEntityReferenceState) {
      case 'selected':
        marker.wrapper.dataset.geolocationEntityReferenceState = 'optional';
        marker.update(null, {icon: this.settings.markerOptionalIconPath});
        this.subscriber.broker.valueRemoved(this.getDeltaByMarker(marker) ?? 0, this.subscriber.constructor.name);
        this.setDeltaByMarker(marker);
        break;

      case 'optional':
      default:
        let delta = 0;
        this.map.wrapper.querySelectorAll("[data-geolocation-widget-delta]").forEach((element) => {
          if (element.dataset.geolocationWidgetDelta >= delta) {
            delta = Number(element.dataset.geolocationWidgetDelta) + 1;
          }
        });
        this.setDeltaByMarker(marker, delta);
        marker.wrapper.dataset.geolocationEntityReferenceState = 'selected';
        marker.update(null, {icon: this.settings.markerSelectedIconPath});
        this.subscriber.broker.valueAdded(
          marker.wrapper.dataset.geolocationEntityReferenceTitle + ' (' + marker.wrapper.dataset.geolocationEntityReferenceId + ')',
          delta,
          this.subscriber.constructor.name
        );
    }
  }
}
