import { GoogleLayerFeature } from "./GoogleLayerFeature.js";

export default class GoogleMarkerZoomByAnchor extends GoogleLayerFeature {
  constructor(settings, map) {
    super(settings, map);

    document.querySelectorAll("a.geolocation-marker-zoom-by-anchor:not(.processed)").forEach((element) => {
      element.classList.add("processed");
      element.on("click", (e) => {
        e.preventDefault();
        let markerAnchor = $(this).attr("href").split("#").pop();

        for (const marker of this.mapMarkers) {
          if (marker.wrapper.getAttribute("data-marker-zoom-anchor-id").replace(/\s/g, "") !== markerAnchor) {
            continue;
          }
          map.wrapper.scrollIntoView();

          let bounds = new google.maps.LatLngBounds();
          let loc = new google.maps.LatLng(marker.position.lat(), marker.position.lng());
          bounds.extend(loc);

          map.googleMap.fitBounds(bounds);
          map.googleMap.panToBounds(bounds);

          marker.setAnimation(google.maps.Animation.BOUNCE);
          window.setTimeout(function () {
            marker.setAnimation(null);
          }, 2000);
        }
      });
    });
  }
}
