import { GeolocationMapFeature } from "./GeolocationMapFeature.js";

/**
 * @property {GeolocationWidgetSubscriberBase} subscriber
 */
export default class GeolocationMarkerScrollToId extends GeolocationMapFeature {
  onMarkerClicked(marker) {
    super.onMarkerClicked(marker);

    let id = marker.wrapper.getAttribute("data-scroll-target-id");

    if (id) {
      document.querySelector("#" + id + ":visible")?.scrollIntoView();
    }
  }
}
