/**
 * @typedef {Object} GeolocationLayerFeatureSettings
 *
 * @property {String} import_path
 * @property {Object} settings
 * @property {String[]} scripts
 * @property {String[]} stylesheets
 */

/**
 * Base class.
 *
 * @property {GeolocationLayerFeatureSettings} settings
 * @property {GeolocationMapBase} map
 */
export class GeolocationLayerFeature {
  /**
   * @constructor
   *
   * @param {GeolocationLayerFeatureSettings} settings
   * @param {GeolocationDataLayer} layer
   */
  constructor(settings, layer) {
    this.settings = settings;
    this.layer = layer;
  }

  /**
   * @param {GeolocationMapMarker} marker
   */
  onMarkerAdded(marker) {}

  /**
   * @param {GeolocationMapMarker} marker
   */
  onMarkerUpdated(marker) {}

  /**
   * @param {GeolocationMapMarker} marker
   */
  onMarkerRemove(marker) {}

  /**
   * @param {GeolocationMapMarker} marker
   */
  onMarkerClicked(marker) {}
}
