/**
 * @typedef {Object} WidgetSubscriberSettings
 *
 * @property {String} import_path
 * @property {Object} settings
 */

/**
 * @property {String} widgetId
 * @property {GeolocationWidgetSubscriberBase[]} subscribers
 * @property {Object} settings
 * @property {int} settings.cardinality
 * @property {String} settings.fieldName
 * @property {WidgetSubscriberSettings[]} settings.widgetSubscribers
 */
export default class GeolocationWidgetBroker {
  constructor(widgetId, settings) {
    this.widgetId = widgetId;
    this.settings = settings;

    this.subscribers = [];
    for (const widgetSubscriberId in this.settings.widgetSubscribers) {
      let widgetSubscriberSetting = this.settings.widgetSubscribers[widgetSubscriberId];

      import(widgetSubscriberSetting.import_path).then((widgetSubscriberImport) => {
        this.subscribers.push(new widgetSubscriberImport.default(this, widgetSubscriberSetting.settings ?? {}));
      });
    }
  }

  /**
   * @param {Number[]} newOrder
   * @param {String} caller
   */
  orderChanged(newOrder /* - Crystal :) */, caller) {
    for (const subscriber of this.subscribers) {
      if (subscriber.constructor.name === caller) {
        continue;
      }
      subscriber.reorder(newOrder, caller);
    }
  }

  /**
   * @param value
   * @param {Number} delta
   * @param {String} caller
   */
  valueAdded(value, delta, caller) {
    for (const subscriber of this.subscribers) {
      if (subscriber.constructor.name === caller) {
        continue;
      }
      subscriber.addValue(value, delta, caller);
    }
  }

  /**
   * @param {Number} delta
   * @param {String} caller
   */
  valueRemoved(delta, caller) {
    for (const subscriber of this.subscribers) {
      if (subscriber.constructor.name === caller) {
        continue;
      }
      subscriber.removeValue(delta, caller);
    }
  }

  /**
   * @param value
   * @param {Number} delta
   * @param {String} caller
   */
  valueAltered(value, delta, caller) {
    for (const subscriber of this.subscribers) {
      if (subscriber.constructor.name === caller) {
        continue;
      }
      subscriber.alterValue(value, delta, caller);
    }
  }
}
