import { GeolocationCoordinates } from "./GeolocationCoordinates.js";
import { GeolocationShape } from "./GeolocationShape.js";

/**
 * @property {Object} geometry
 * @property {Object[{points: GeolocationCoordinates[]}]} geometry.lines
 * @property {String} strokeColor
 * @property {String} strokeOpacity
 * @property {String} strokeWidth
 * @property {String} fillColor
 * @property {String} fillOpacity
 */
export class GeolocationShapeMultiLine extends GeolocationShape {
  /**
   * @param {Object} geometry
   * @param {GeolocationShapeSettings} settings
   * @param {GeolocationMapBase} map
   * @param {String} layerId
   */
  constructor(geometry, settings = {}, map = null, layerId = 'default') {
    super(geometry, settings, map, layerId);

    this.type = "multipolygon";

    this.strokeColor = settings.strokeColor;
    this.strokeOpacity = settings.strokeOpacity;
    this.strokeWidth = settings.strokeWidth;
  }

}
