/**
 * @property {Number}  north
 * @property {Number}  east
 * @property {Number}  south
 * @property {Number}  west
 */
export class GeolocationBoundaries {

  /**
   * @param {Object} boundaries
   *
   * Alternatively pass:
   *   - northEast, southWest objects
   *   - north, east, south, west primitives
   *
   * @todo: Add range checks.
   */
  constructor(boundaries) {

    switch (arguments.length) {
      case 1:
        this.north = Number(boundaries.north);
        this.east = Number(boundaries.east);
        this.south = Number(boundaries.south);
        this.west = Number(boundaries.west);
        break;

      case 2:
        this.north = Number(arguments[0][0]);
        this.east = Number(arguments[0][1]);
        this.south = Number(arguments[1][0]);
        this.west = Number(arguments[1][1]);
        break;

      case 4:
        this.north = Number(arguments[0]);
        this.east = Number(arguments[1]);
        this.south = Number(arguments[2]);
        this.west = Number(arguments[3]);
        break;

      default:
        throw 'GeolocationBoundary could not be created.';
    }
  }

  /** @param {GeolocationBoundaries} bounds */
  equals(bounds) {
    if (!bounds) {
      return false;
    }

    let equal = false;

    let precision = 5;
    if (
        this.north.toFixed(precision) === bounds.north.toFixed(precision)
        && this.east.toFixed(precision) === bounds.east.toFixed(precision)
        && this.south.toFixed(precision) === bounds.south.toFixed(precision)
        && this.west.toFixed(precision) === bounds.west.toFixed(precision)
    ) {
      equal = true;
    }

    return equal;
  }
}
