import { GeolocationGeocodedResult } from "../GeolocationGeocodedResult.js";

/**
 * @typedef {Object} GeolocationGeocoderSettings
 *
 * @property {int} autocomplete_min_length
 */

/**
 * @property {GeolocationGeocoderSettings} settings
 * @property {array} resultCallbacks
 * @property {array} clearCallbacks
 */
export class GeolocationGeocoder {
  constructor(settings) {
    this.settings = settings;

    this.resultCallbacks = [];
    this.clearCallbacks = [];
  }

  addResultCallback(callback) {
    this.resultCallbacks.push(callback);
  }

  addClearCallback(callback) {
    this.resultCallbacks.push(callback);
  }

  /**
   *
   * @param {GeolocationGeocodedResult} result
   */
  resultCallback(result) {
    this.resultCallbacks.forEach((callback) => {
      callback(result);
    });
  }

  clearCallback() {
    this.clearCallbacks.forEach((callback) => {
      callback();
    });
  }

  /**
   * @param {String} address
   *
   * @return {Promise}
   */
  geocode(address) {}

  /**
   *
   * @param {HTMLElement} geocoderInput
   */
  attachToElement(geocoderInput) {
    if (!geocoderInput) {
      console.error("No geocoding input element. No Geocoding.");
      return;
    }

    if (!jQuery) {
      console.error("No jQuery present. Cannot autocomplete. No Geocoding selection.");
      return;
    }

    geocoderInput.addEventListener("input", () => {
      this.clearCallback();
    });

    jQuery(geocoderInput).autocomplete({
      autoFocus: true,
      minLength: this.settings.autocomplete_min_length ?? 1,
      source: (request, response) => {
        let autocompleteResults = [];

        this.geocode(request.term).then((results) => {
          for (const result of results) {
            autocompleteResults.push({
              value: result.label,
              geocodedResult: result.geocodedResult,
            });
          }
          response(autocompleteResults);
        });
      },

      /**
       * Option form autocomplete selected.
       *
       * @param {Object} event - See jquery doc
       * @param {Object} ui - See jquery doc
       * @param {Object} ui.item - See jquery doc
       */
      select: (event, ui) => {
        this.resultCallback(ui.item.geocodedResult);
      },
    });
  }
}
