import {default as GeolocationDataLayer} from "./GeolocationDataLayer.js";

export default class DefaultLayer extends GeolocationDataLayer {

  async loadMarkers(selector) {
    selector = ".geolocation-location:not(.geolocation-map-layer .geolocation-location)"
    return super.loadMarkers(selector);
  }

  async loadShapes(selector) {
    selector = ".geolocation-geometry:not(.geolocation-map-layer .geolocation-geometry)"
    return super.loadShapes(selector);
  }

  addMarker(marker) {
    super.addMarker(marker);

    for (const feature of this.map.features) {
      try {
        feature.onMarkerAdded(marker);
      } catch (e) {
        console.error("Feature failed onMarkerAdded: " + e.toString());
      }
    }

    return marker;
  }

  updateMarker(marker) {
    super.updateMarker(marker);

    for (const feature of this.map.features) {
      try {
        feature.onMarkerUpdated(marker);
      } catch (e) {
        console.error("Feature failed onMarkerUpdated: " + e.toString());
      }
    }
  }

  removeMarker(marker) {
    super.removeMarker(marker);

    for (const feature of this.map.features) {
      try {
        feature.onMarkerRemove(marker);
      } catch (e) {
        console.error("Feature failed onMarkerRemove: " + e.toString());
      }
    }
  }

  clickMarker(marker) {
    super.clickMarker(marker);

    for (const feature of this.map.features) {
      try {
        feature.onMarkerClicked(marker);
      } catch (e) {
        console.error("Feature failed onMarkerRemove: " + e.toString());
      }
    }
  }
}
