<?php

namespace Drupal\Tests\flag\Functional;

/**
 * Tests views of Flaggings.
 *
 * @group flag
 */
class FlaggingViewTest extends FlagTestBase {

  /**
   * Modules to enable.
   *
   * @var array
   */
  protected static $modules = [
    'flag_follower',
    'flag_bookmark',
    'flagging_admin_test',
  ];

  /**
   * A node to bookmark.
   *
   * @var \Drupal\node\NodeInterface
   */
  protected $node;

  /**
   * {@inheritdoc}
   */
  public function setUp(): void {
    parent::setUp();

    // Create a node to bookmark.
    $this->node = $this->drupalCreateNode([
      'body' => [
        [
          'value' => $this->randomMachineName(32),
          'format' => filter_default_format(),
        ],
      ],
      'type' => $this->nodeType,
      'title' => $this->randomMachineName(8),
      'uid' => $this->adminUser->id(),
      'status' => 1,
      'promote' => 1,
      'sticky' => 0,
    ]);

    // Create a user to follow.
    $auth_user = $this->drupalCreateUser([
      'flag bookmark',
      'flag following',
    ]);

    // Bookmark the node.
    $bookmark_flag = $this->flagService->getFlagById('bookmark');
    $this->flagService->flag($bookmark_flag, $this->node, $auth_user);

    // Follow the admin user.
    $follower_flag = $this->flagService->getFlagById('following');
    $this->flagService->flag($follower_flag, $this->adminUser, $auth_user);
  }

  /**
   * Test the flagging admin view.
   */
  public function testFlaggingView() {
    // Login as the admin.
    $this->drupalLogin($this->adminUser);

    // Go to the view.
    $this->drupalGet('admin/structure/flags/testing');

    // Check if there's a bookmark flagging.
    $this->assertSession()->pageTextContains('Bookmark');

    // Check if there's a node title. This would come from the entity
    // relationship on the flagging view.
    $this->assertSession()->pageTextContains($this->node->getTitle());

    // Check if there's a following flagging.
    $this->assertSession()->pageTextContains('Following');
  }

}
